max_entities = 0

entities = new Array();

entities[0] = new Object();
entities[0].x = 0;
entities[0].y = 0;
entities[0].vx = 0;
entities[0].vy = 0;
entities[0].name = "main1"
entities[0].dir = "east"

entities[1] = new Object();
entities[1].x = 0;
entities[1].y = 0;
entities[1].vx = 0;
entities[1].vy = 0;
entities[1].name = "main2"
entities[1].dir = "west";


g_const = 0.2//gravitiy const

function LoadMapEntities(first_time)
{
	person_list = GetPersonList()
	counter = 0;
	
	if (first_time == true)
	{
		entities[0] = new Object();
		entities[0].x = GetPersonX("main1");
		entities[0].y = GetPersonY("main1");
		entities[0].vx = 0;
		entities[0].vy = 0;
		entities[0].name = "main1"
		entities[0].dir = 1
		entities[0].direction = "walk";
		entities[0].type = 1
		entities[0].level = 0
		entities[0].frame = 0

		entities[1] = new Object();
		entities[1].x = GetPersonX("main2");
		entities[1].y = GetPersonY("main2");
		entities[1].vx = 0;
		entities[1].vy = 0;
		entities[1].name = "main2"
		entities[1].direction = "walk";
		entities[1].dir = -1
		entities[1].type = 2
		entities[1].level = 1
		entities[1].frame = 0
	}

  counter = 2 
  
  for (var i=0; i<person_list.length;i++)
  {
		type = -1;
		if (GetPersonSpriteset(person_list[i]) == "enemy1.rss")
			type=3;
		
		if (type > 2)
		{
		  if (entities.length < counter)
				entities[counter] = new Object();
				
			entities[counter].x = GetPersonX(person_list[i])
			entities[counter].y = GetPersonY(person_list[i])
			entities[counter].dir = "east"
			entities[counter].name = person_list[i]
			entities[counter].vx = 0
			entities[counter].vy = 0 
		}
		counter+=1
		
	}
	max_entities = counter+1;

}

face = new Array()
face[1] = "east"
face[-1] = "west"

walk_default_frame = 2
entity_layer = 3
function UpdateEntities(sound_override)
{
	for (var i=0;i<entities.length;i++)
	{
		if (entities[i].level != g_level)
		{
			SetPersonX(entities[i].name, -100);
			
		}
		else
		{
      SetPersonLayer(entities[i].name, entity_layer)
			//update physics
			entities[i].vy += g_const
			//update position of this entity according to velocities
			entities[i].x+=entities[i].vx;
			entities[i].y+=entities[i].vy;
			if (IsEntityObstructed(i, entities[i].x, entities[i].y))
			{
				entities[i].x-=entities[i].vx;
				entities[i].y-=entities[i].vy;
				if (IsEntityObstructed(i, entities[i].x+entities[i].vx, entities[i].y))
				{
					entities[i].vx = 0
				}
				if (IsEntityObstructed(i, entities[i].x, entities[i].y+entities[i].vy))
				{
					entities[i].vy = 0
				} 
					
				if (!IsEntityObstructed(i, entities[i].x+entities[i].vx, entities[i].y+entities[i].vy))
				{
					entities[i].x += entities[i].vx;
					entities[i].y += entities[i].vy;     
				}
				else//entity's on a corner
				{
					entities[i].vx = 0;
					entities[i].vy = 0
				}
			}
			SetPersonXYFloat(entities[i].name, entities[i].x*scale_x, entities[i].y*scale_y)
			//Set the animation frames
			SetPersonDirection(entities[i].name, entities[i].direction+"_"+face[entities[i].dir])
			if (g_frames%g_frame_updater == 0)
			{
				if (entities[i].direction == "walk" && IsEntityObstructed(i, entities[i].x, entities[i].y+1) == true)
				{
					if (Math.abs(entities[i].vx) > 0)
					{
						SetPersonFrame(entities[i].name, GetPersonFrame(entities[i].name)+1);
					}
					else
					{
						if (GetPersonFrame(entities[i].name) != 2 && GetPersonFrame(entities[i].name) != 6)
							SetPersonFrame(entities[i].name, walk_default_frame);
					}
					
				}
				else if (entities[i].direction == "die")
				{
						SetPersonFrame(entities[i].name, GetPersonFrame(entities[i].name)+1);
						if (GetPersonFrame(entities[i].name) == 5 && i == 0)
						{
							DieSwitchOver();
						}
						if (GetPersonFrame(entities[i].name) == 0)
						{
							entities[i].direction = "walk"
							entities[i].frame = 2;
							SetPersonFrame(entities[i].name, 2)
							SetPersonDirection(entities[i].name, "walk_"+face[entities[i].dir])
						}
				}
				
			}
			if (IsEntityObstructed(i, entities[i].x, entities[i].y+1) == false && entities[i].direction != "die")
			{
				SetPersonDirection(entities[i].name, "jump_"+face[entities[i].dir])
				if (entities[i].vy < 0)
					SetPersonFrame(entities[i].name, 0);
				else
					SetPersonFrame(entities[i].name, 1);
			}
			

			//slow down entities now:
			if (IsEntityObstructed(i,entities[i].x, entities[i].y+1)  || true)
			{
					if (entities[i].vx > 0)
						 entities[i].vx-=0.25;
					if (entities[i].vx < 0)
						 entities[i].vx+=0.25;
						 
					if (Math.abs(entities[i].vx) < 0.25)
							entities[i].vx = 0
			}
			entities[i].frame = GetPersonFrame(entities[i].name);
			if (entities[i].name == 'main1')
			{
				CheckDead(i);
				CheckSwitch(i, sound_override);
			}
		}
	}
}

function IsEntityObstructed(i, x,y)
{
	res = false
	old_layer = GetPersonLayer(entities[i].name)
	SetPersonLayer(entities[i].name, 0)
	if (IsPersonObstructed(entities[i].name,x,y))
	{
		res= true;
	}
	if (entities[i].name != "main2")
	{
		SetPersonLayer(entities[i].name, 1)
		if (IsPersonObstructed(entities[i].name,x,y))
		{
			res= true;
		}
	
	}
	
	SetPersonLayer(entities[i].name, old_layer);
	return res
	

}

function CheckDead(i)
{
	if (entities[i].direction != "die")
	{
		x = Math.floor(GetPersonX(entities[i].name)/(GetTileWidth()*scale_x));
		y = Math.floor((GetPersonY(entities[i].name)-8)/(GetTileHeight()*scale_y));
		
		tile = GetTile(x,y,0)
		if (tile == 6 || IsEntityObstructed(0, entities[0].x, entities[0].y))
		{
			PlaySound(2);
			entities[0].direction = "die";
			entities[1].direction = "die";
			SetPersonDirection(entities[0].name, "die_"+face[entities[0].dir])
			SetPersonDirection(entities[1].name, "die_"+face[entities[1].dir])
			SetPersonFrame(entities[0].name, 0);
			SetPersonFrame(entities[1].name, 0);
			entities[0].vx = 0;
			entities[0].vy = 0;
			entities[1].vx = 0;
			entities[1].vy = 0;
			
		}
		
	}
}


function DieSwitchOver()
{
		g_user = (g_user+1)%2
		keys = ["x", "y", "level", "dir", "direction", "frame", "vx", "vy"]
		for (var i=0;i<keys.length;i++)
		{
			key = keys[i]
			temp = entities[0][key]
			entities[0][key] = entities[1][key];
			entities[1][key] = temp;
			entities[0].frame = 5;
			entities[1].frame = 5;
		}
		for (var i=0;i<2;i++)
		{
			SetPersonDirection(entities[i].name, "die_"+face[entities[i].dir])
			SetPersonFrame(entities[i].name, 5)
		}	
}

function CheckSwitch(i, sound_override)
{
	x = Math.floor(GetPersonX(entities[i].name)/(GetTileWidth()*scale_x));
	y = Math.floor((GetPersonY(entities[i].name)-8)/(GetTileHeight()*scale_y));
	
	tile = GetTile(x,y,0)
	if (tile == 7 || tile == 8|| tile == 9)
	{
	  index = tile-7;
	  if (levels[g_level].switches[index][0] != 1)
	  {
			if (sound_override != true)
				PlaySound(5);

			levels[g_level].switches[index][0] = 1//swtich is active
			levels[g_level].switches[index][2] = x;//store x and y for changing between levels.
			levels[g_level].switches[index][3] = y;
			
			//SetTile(x,y,0, 0);
			SetTile(x,y,3, 133);
			
			eval(levels[g_level].switches[index][1]);
		}
	}
}

function UpdateReleaseSwitches()
{
	if (levels[g_level].switches != undefined)
	{
		for (var i=0;i<levels[g_level].switches.length;i++)
		{
			switchy = levels[g_level].switches[i];
			if (switchy[4] != undefined)
			{
				if (switchy[0] == 1)//switch is currently active
				{
					x = Math.floor(GetPersonX(entities[0].name)/(GetTileWidth()*scale_x));
					y = Math.floor((GetPersonY(entities[0].name)-8)/(GetTileHeight()*scale_y));
					tile = GetTile(x,y,0)
					if (tile != 7 && tile != 8 && tile != 9)
					{
						switchy[0] = 0
						eval(switchy[4])
						ResetSwitches()
					}
					
				}
			}
		}
	}
}

function ResetSwitches()
{
	if (levels[g_level].switches != undefined)
	{
		for (var i=0;i<levels[g_level].switches.length;i++)
		{
			switchy =levels[g_level].switches[i]
			if (switchy[0] == 1)
			{
				x = switchy[2];
				y = switchy[3];
				SetTile(x,y,0,0);
				SetTile(x,y,3, 133);
			}
			else if (switchy[2] != undefined && switchy[3]!=undefined)
			{
				x = switchy[2];
				y = switchy[3];
				SetTile(x,y,0,7+i);
				SetTile(x,y,3, 132);
				
			}
		}
	}
}
